﻿Public Class Form1
    Dim m_pOrigin As Origin.IOApplication
    Dim m_mtxPage As Origin.MatrixPage
    Dim m_mtxSheet As Origin.MatrixSheet
    Dim m_mtxObj As Origin.MatrixObject
    Dim m_plot As Origin.DataPlot
    Dim m_nSendCount As Integer
    Const NUM_COLS = 600
    Const NUM_ROWS = 500
    Const NUM_COLORS = 256

    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Call EnableControls(False)
    End Sub

    Private Sub EnableControls(ByVal bConnected As Boolean)
        ButtonSendOnce.Enabled = bConnected
        ButtonSetColormap.Enabled = bConnected
        ButtonSetPlotColors.Enabled = bConnected
        ButtonStartStop.Enabled = bConnected

        ButtonConnectAndInit.Enabled = Not bConnected
    End Sub

    Private Sub ConnectAndPrepare()
        m_pOrigin = New Origin.ApplicationSI()
        m_pOrigin.NewProject()
        m_pOrigin.Visible = Origin.MAINWND_VISIBLE.MAINWND_SHOW

        m_mtxPage = m_pOrigin.MatrixPages.Add()
        m_mtxSheet = m_pOrigin.FindMatrixSheet("")
        m_mtxSheet.Cols = NUM_COLS
        m_mtxSheet.Rows = NUM_ROWS
        m_mtxObj = m_mtxSheet.MatrixObjects.Add()
        m_mtxObj.DataFormat = Origin.COLDATAFORMAT.DF_USHORT
        m_mtxObj.ViewImage = True

        EnableControls(True) ' once connected, should update buttons status

    End Sub

    Private Sub ClickStartStop()

    End Sub
    Private Sub SendData()
        Dim usData(0 To NUM_ROWS - 1, 0 To NUM_COLS - 1) As UShort
        Dim nn As Integer
        m_nSendCount += 1
        nn = m_nSendCount

        For iRow = 0 To NUM_ROWS - 1
            For iCol = 0 To NUM_COLS - 1
                Dim kk As Integer, even As Integer
                kk = iRow + iCol
                even = nn Mod 2 'every other time will flip the matrix
                If even = 1 And iRow > NUM_ROWS / 2 Then
                    kk = (NUM_COLS + NUM_ROWS - 2) - kk
                End If
                usData(iRow, iCol) = CUShort(kk)
            Next
        Next
        m_mtxObj.SetData(usData, 0, 0)
        TextBoxMessage.Text = nn.ToString() + " .sending..."
    End Sub
    Private Function SetZColormap(ByRef colormap As Origin.ColorMap) As Boolean
        'initiliaze the colormap to view the image, if 1 color, then need Z below and above, so n+1
        Dim zLevels(0 To NUM_COLORS) As Double
        Dim zColor(0 To NUM_COLORS - 1) As Integer

        For ii = 0 To NUM_COLORS
            zLevels(ii) = ii * (NUM_COLS + NUM_ROWS - 2) / NUM_COLORS
        Next

        For jj = 0 To NUM_COLORS - 1
            Dim red As Integer, blue As Integer
            red = jj * 255 / (NUM_COLORS - 1)
            blue = (NUM_COLORS - 1 - jj) * 255 / (NUM_COLORS - 1)
            'generate color ramp from Blue to Red, no Green
            zColor(jj) = RGB(red, 0, blue)
        Next

        Return colormap.SetLevels(zLevels, zColor)
    End Function

    Public Sub New()


        InitializeComponent()


    End Sub

    Private Sub ButtonConnectAndInit_MouseClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles ButtonConnectAndInit.MouseClick
        Call ConnectAndPrepare()
    End Sub

    Private Sub ButtonStartStop_MouseClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles ButtonStartStop.MouseClick
        If Not myTimer.Enabled Then
            myTimer.Interval = CInt(ComboBoxDelay.Text)
            ButtonStartStop.Text = "Stop"
            myTimer.Start()
        Else
            ButtonStartStop.Text = "Start"
            myTimer.Stop()
        End If
    End Sub

    Private Sub myTimer_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles myTimer.Tick
        If Not m_mtxObj Is Nothing Then
            Call SendData()
        Else
            TextBoxMessage.Text = "m_mtxObj is null"
        End If
    End Sub

    Private Sub ButtonSetPlotColors_MouseClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles ButtonSetPlotColors.MouseClick
        If m_plot Is Nothing Then
            Dim gl As Origin.GraphLayer
            gl = m_pOrigin.FindGraphLayer("Graph1")
            If Not gl Is Nothing Then
                m_plot = gl.DataPlots(0)
            End If
        End If
        If m_plot Is Nothing Then
            TextBoxMessage.Text = "m_plot is null"
        Else
            If SetZColormap(m_plot.ColorMap) Then
                TextBoxMessage.Text = "set colormap done!"
            Else
                TextBoxMessage.Text = "set colormap failed"
            End If
        End If
    End Sub

    Private Sub ButtonSetColormap_MouseClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles ButtonSetColormap.MouseClick
        If m_mtxObj Is Nothing Then
            TextBoxMessage.Text = "m_mtxObj is null"
        Else
            If SetZColormap(m_mtxObj.ColorMap) Then
                TextBoxMessage.Text = "colormap done"
            Else
                TextBoxMessage.Text = "set colormap failed"
            End If
        End If
    End Sub

    Private Sub ButtonSendOnce_MouseClick(ByVal sender As System.Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles ButtonSendOnce.MouseClick
        Call SendData()
    End Sub
End Class
